#include <time.h>

extern volatile unsigned short __attribute__((__sfr__(0x106))) TMR2;
extern volatile unsigned short __attribute__((__sfr__(0x108))) TMR3H;
extern volatile unsigned short __attribute__((__sfr__(0x10A))) TMR3;
extern volatile unsigned short __attribute__((__sfr__(0x110))) T2CON;

#define	T2ON	0x8000u
#define	T32	0x0008u

time_t __attribute__((__weak__))
time(time_t *pt)
{
	time_t t;

	if ((T2CON & T2ON) == 0)
	{
		T2CON |= T32;
		T2CON |= T2ON;
	}
	t = ((time_t *)(&TMR2))[0];
	if (pt)
	{
		*pt = t;
	}
	return(t);
}
